import os
import numpy as np
import re 
import datetime
import torch
from torch.nn import parameter
import shutil

def mkdir(fn):  # Create a directory
    if not os.path.isdir(fn):
        os.mkdir(fn)


def create_save_dir(path_ori, m, t):
    mkdir(path_ori)
    path1 = '%s%s/' % (path_ori, m)
    mkdir(path1)
    path = '%s%s/' % (path1, t)
    mkdir(path)
    # subFolderName = '%s' % (
        # int(np.absolute(np.random.normal([1]) * 100000)) // int(1))
    subFolderName =re.sub(r'[^0-9]','',str(datetime.datetime.now()))
    path = '%s%s/' % (path, subFolderName)
    mkdir(path)
    mkdir('%soutput/'%(path))

    return path


class CheckpointSaver:
    def __init__(
            self,
            model,
            optimizer,
            args=None,
            path='',
            extension='.pth.tar'

    ):

        # objects to save state_dicts of
        self.model = model
        self.optimizer = optimizer
        self.args = args

        # state
        # (filename, metric) tuples in order of decreasing betterness
        self.checkpoint_files = []
        self.best_epoch = None
        self.best_metric = None
        self.curr_recovery_file = ''
        self.last_recovery_file = ''

        # config
        self.checkpoint_dir = path
        self.extension = extension

    def save_checkpoint(self, epoch):
        assert epoch >= 0
        self.args.model_dirs = os.path.join(self.checkpoint_dir, 'model')
        mkdir(self.args.model_dirs)
        tmp_save_path = os.path.join(
            self.args.model_dirs, 'tmp' + self.extension)

        self._save(tmp_save_path, epoch)

    def _save(self, save_path, epoch):
        save_state = {
            'epoch': epoch,
        }
        if self.model is not None:
            save_state['arch'] = type(self.model).__name__.lower(),
            save_state['state_dict'] = self.model.state_dict(),
        if self.optimizer is not None:
            save_state['optimizer'] = self.optimizer.defaults
        if self.args is not None:
            # save_state['arch'] = self.args.model
            save_state['args'] = self.args
        torch.save(save_state, save_path)
        return save_state


def save_code_and_config(name,target_path):
    # print('./%s/'%(name))
    # print( os.path.join(target_path,name))
    mkdir(os.path.join(target_path,'code'))
    shutil.copytree('./%s/'%(name), os.path.join(target_path,'code',name))
